import { z } from "zod";
import { agencyAccessSchema, validationStatusOptionExtendedSchema } from "./feeds.schema";

const agencyErrorSchema = z.object({
  message: z.string().optional()
})

const agencyStatusSchema = z.object({
  started: z.date().optional(),
  option: validationStatusOptionExtendedSchema,
})

const agencyDatesSchema = z.object({
  uploaded: z.date().optional(),
  uploadedToPreview: z.date().optional(),
  uploadedToLive: z.date().optional(),
})

export const transformedAgencySchema = z.object({
  access: agencyAccessSchema,
  id: z.string(),
  gtfsId: z.string(),
  name: z.string(),
  url: z.string(),
  phone: z.string(),
  path: z.string(),
  error: agencyErrorSchema,
  status: agencyStatusSchema,
  dates: agencyDatesSchema,
})

export const transformedAgenciesSchema = z.array(transformedAgencySchema)

export type AppTransformedAgenciesSchema = z.infer<typeof transformedAgenciesSchema>
export type AppTransformedAgencySchema = z.infer<typeof transformedAgencySchema>
export type AppTransformedAgencyDates = z.infer<typeof agencyDatesSchema>
